﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

//
using DotNet.FrameWork.Data;
using System.Data.SqlClient;
using System.Data;
using DotNet.FrameWork.Common.Encrypt;

namespace HteamDd.Web.Web
{
    public partial class Dd_login : System.Web.UI.Page
    {
       
        protected void Page_Load(object sender, EventArgs e)
        {
           
        }

        protected void Page_Init(object sender, EventArgs e)
        {
            if (Request.Cookies["login"] != null)
            {
                if (Session["count"] == null)
                {
                    Session["count"] = "1";
                    int num=Cookie_prc();
                    if (num == 1)
                    {
                        Response.Redirect("Default.aspx");
                    }
                }
            }
        }

        private int Cookie_prc()
        {
            string cookievalue = Request.Cookies["login"].Value;
            if (cookievalue != "")
            {
                string user_ID = Request.Cookies["login"]["user_ID_org"];
                if (check_user(user_ID))
                {
                    return 1;
                }
                else
                {
                    return 0;
                }
            }
            else
            {
                return 0;
            }
        }

        public bool check_user(string user_ID)
        {
            string user_sql = "select User_ID,User_BlogName,User_Email from Dd_User where User_ID=@ID";
            SqlParameter parm = new SqlParameter("@ID", SqlDbType.Int);
            parm.Value = Convert.ToInt32(user_ID);
            try
            {
                SqlDataReader dr = DbHelperSQL.ExecuteReader(user_sql, parm);
                dr.Read();
                if (Encrypt.EncryptPassword(dr["User_ID"].ToString(), "MD5") == Request.Cookies["login"]["user_ID"])
                {
                    string user_data = dr["User_ID"].ToString() + "," + dr["User_BlogName"].ToString() + "," + dr["User_Email"].ToString();
                    Session["user_Message"] = user_data;
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch(Exception ex)
            {
                return false;
            }
        }
    }
}